<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Branch;
use App\Models\Doctor;
use App\Models\Pharmacist;
use App\Models\Setting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create branches
        $branch1 = Branch::create([
            'name' => 'Branch 1 - Maseru',
            'address' => 'Maseru, Lesotho',
            'phone' => '+266 1234 5678',
            'email' => 'branch1@beautez.com',
        ]);

        $branch2 = Branch::create([
            'name' => 'Branch 2 - Leribe',
            'address' => 'Leribe, Lesotho',
            'phone' => '+266 1234 5679',
            'email' => 'branch2@beautez.com',
        ]);

        $branch3 = Branch::create([
            'name' => 'Branch 3 - Mafeteng',
            'address' => 'Mafeteng, Lesotho',
            'phone' => '+266 1234 5680',
            'email' => 'branch3@beautez.com',
        ]);

        // Create admin user
        $adminUser = User::create([
            'name' => 'Admin User',
            'email' => 'admin@beautez.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        // Create doctor user
        $doctorUser = User::create([
            'name' => 'Dr. John Doe',
            'email' => 'doctor@beautez.com',
            'password' => Hash::make('password'),
            'role' => 'doctor',
            'is_active' => true,
        ]);

        Doctor::create([
            'user_id' => $doctorUser->id,
            'title' => 'Dr.',
            'first_name' => 'John',
            'last_name' => 'Doe',
            'specialization' => 'General Practice',
            'qualification' => 'MD (Gastroenterology)',
            'practice_number' => '0025454',
            'country' => 'Lesotho',
            'educational_details' => 'Medical Degree from University of Lesotho',
            'phone' => '+266 1234 5678',
            'email' => 'doctor@beautez.com',
            'is_verified' => true,
            'is_active' => true,
            'verified_at' => now(),
        ]);

        // Create pharmacist user
        $pharmacistUser = User::create([
            'name' => 'Pharmacist User',
            'email' => 'pharmacist@beautez.com',
            'password' => Hash::make('password'),
            'role' => 'pharmacist',
            'is_active' => true,
        ]);

        Pharmacist::create([
            'user_id' => $pharmacistUser->id,
            'branch_id' => $branch1->id,
            'first_name' => 'Jane',
            'last_name' => 'Smith',
            'phone' => '+266 1234 5678',
            'license_number' => 'PHARM001',
            'is_active' => true,
        ]);

        // Create default settings
        Setting::set('patient_registration_enabled', false, 'boolean');
    }
}

